#include <BWAPI.h>
#include <BWTA.h>
#include <math.h>
//#include "QueenManager"
#include "ZerglingManager.h"

#pragma once
using namespace BWAPI;

//best so far 2:50 PM

class ArmyManager
{
public:
	Position HuntersMark;
	Unit* TargetEnemy;
	int pacer;
	int mindist;
	int distance;
	int wcount;
	int eggcount;
	int spcount;
	int excount;
	int gassers;
	int lgassers;
	int hcount;
	int zcount;
	int lucount;
	int lcount;
	int spccount;
	int sccount;
	int hacount;
	int mcount;
	int spicount;
	int qcount;
	int quncount;
	int scocount;
	int ax;
	int ay;
	int totalDist;
	bool brooding;
	bool inRange;
	bool rushed;
	bool twoPlayers;
	Unit* SniperTarget;
	Unit* DetectorMain;
	Unit* DetectorSafe;
	Unit* DetectorReserve;
	Unit* closestMineral;
	Unit* extractor;
	Unit* extractor2;
	Position HunterKiller;
	Position OnDeck;
	Position SafeSpot;
	Position hatcheryPosition;
	bool aggression;
	bool searching;
	bool hasInfantry;
	bool top;
	bool bottom;
	bool left;
	bool right;
	int defenseOne;
	int defenseTwo;
	int baseRange;
	ZerglingManager	zerglingManager;
	//QueenManager queenManager;

	TilePosition buildsp, buildcc1, buildcc2, buildcc3, buildcc4, buildcc5, buildev, buildhd, 
	buildha1, buildex, buildspi, buildha2, buildha3, buildex2, buildqu;

	ArmyManager(void)
	{
		pacer = 0;
		totalDist = 0;
		HunterKiller = Position(Broodwar->self()->getStartLocation());
		SafeSpot = Position(Broodwar->self()->getStartLocation());
		OnDeck = Position(Broodwar->self()->getStartLocation());
		HuntersMark = Position(Broodwar->self()->getStartLocation());
		extractor = NULL;
		extractor2 = NULL;
		defenseOne = -1;
		defenseTwo = -1;
		baseRange = 100;
		closestMineral = NULL;
		rushed =false;

		this->assignMap();
	}
	~ArmyManager(void)
	{
	}

	void onFrame(BWAPI::Game *Broodwar)
	{
		//count units in army
		this->armyCounter(Broodwar);
		this->setFlags();
		this->workerDefender();


		//unit manager
		for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
		{		
			brooding = false;

			this->build();

			if(this->gasBreak((*i)))
				break;

			//things to do if you're a worker
			if((*i)->getType().isWorker())
			{
				this->armyWorker(Broodwar, (*i));
			}

			//things to do if you're a worker
			if((*i)->getType().isResourceDepot())
			{
				this->armyBase(Broodwar, (*i));
			}

			//if a zergling
			if ((*i)->getType()==UnitTypes::Zerg_Zergling)
			{
				this->zerglingManager.onFrame(Broodwar);
				if(hasInfantry)
					this->armyZergling(Broodwar, (*i));
			}

			//if a broodling
			if ((*i)->getType()==UnitTypes::Zerg_Broodling)
			{
				this->armyBroodling(Broodwar, (*i));
			}

			//if a hydralisk
			if ((*i)->getType()==UnitTypes::Zerg_Hydralisk)
			{
				this->armyHydralisk(Broodwar, (*i));
			}

			//if a lurker
			if ((*i)->getType()==UnitTypes::Zerg_Lurker)
			{
				this->armyLurker(Broodwar, (*i));
			}

			// if mutalisk
			if ((*i)->getType()==UnitTypes::Zerg_Mutalisk)
			{
				this->armyMutalisk(Broodwar, (*i));
			}

			//if scourge
			if ((*i)->getType()==UnitTypes::Zerg_Scourge)
			{
				this->armyScourge(Broodwar, (*i));
			}

			//if a hydralisk den
			if ((*i)->getType()==UnitTypes::Zerg_Hydralisk_Den)
			{
				this->armyHydraliskDen((*i));
			}

			//if a queen's nest
			if ((*i)->getType()==UnitTypes::Zerg_Queens_Nest)
			{
				this->armyQueensNest((*i));
			}

			//if queen
			if ((*i)->getType()==UnitTypes::Zerg_Queen)
			{
				this->armyQueen((*i));
			}

			//if creep colony
			if ((*i)->getType()==UnitTypes::Zerg_Creep_Colony)
			{
				this->armyColony(Broodwar, (*i));
			}
		
			if(pacer%10==0 && hasInfantry)
			{
				this->findTargets();

				this->overlordRoles();
	
				this->gatherFlyers();

				this->gatherInfantry();
		
				this->moveArmy();

				this->drawCircles();
			}
			/*
			if(pacer % 10 == 1 || pacer % 10 == 2)
			{
				for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
				{
					this->circleOverlords((*i));

					this->circleScourge((*i));
				}
			}
			*/
		}
	}
	void onUnitDestroy(BWAPI::Game *Broodwar, BWAPI::Unit* unit)
	{	
		if (unit->getPlayer()==Broodwar->self() && (unit->getType()==UnitTypes::Zerg_Hydralisk || unit->getType()==UnitTypes::Zerg_Zergling)){
			HuntersMark = unit->getPosition();
			TargetEnemy = unit;
		}
	}
	void onUnitDiscover(BWAPI::Game *Broodwar, BWAPI::Unit* unit)
	{
		if (unit->getPlayer()==Broodwar->enemy()){
			HuntersMark = unit->getPosition();
			TargetEnemy = unit;
		}
	}
	bool shouldBrood(BWAPI::Unit* unit)
	{
		if(unit->getType() == UnitTypes::Terran_Siege_Tank_Siege_Mode ||
		unit->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode ||
		unit->getType() == UnitTypes::Terran_Goliath ||
		unit->getType() == UnitTypes::Protoss_High_Templar ||
		unit->getType() == UnitTypes::Protoss_Dark_Templar ||
		unit->getType() == UnitTypes::Protoss_Dragoon ||
		unit->getType() == UnitTypes::Zerg_Defiler ||
		unit->getType() == UnitTypes::Zerg_Lurker ||
		unit->getType() == UnitTypes::Zerg_Ultralisk)
			return true;
		else
			return false;	
	}

	bool shouldBurrow(BWAPI::Unit* unit)
	{
		inRange = false;
		for(std::set<Unit*>::const_iterator e=Broodwar->enemy()->getUnits().begin();e!=Broodwar->enemy()->getUnits().end();e++)
		{
			if ((*e)->getHitPoints()>0 && (*e)->getDistance(unit->getPosition())<(5*32) &&
				(*e)->getType().canAttack() && !((*e)->getType().isWorker()) && 
				(*e)->getType().groundWeapon().targetsGround() && zcount <= 10 && 
				((*e)->getDistance(Position(Broodwar->self()->getStartLocation()))>1000))
					return true;
		}
		return false;
	}

	void armyWorker(BWAPI::Game *Broodwar, BWAPI::Unit* unit)
	{
		if(unit->getOrder()==Orders::PlayerGuard){
			for(std::set<Unit*>::iterator m=Broodwar->getMinerals().begin();m!=Broodwar->getMinerals().end();m++)
			{
			  if (closestMineral==NULL || unit->getDistance(*m)<unit->getDistance(closestMineral))
				closestMineral=*m;
			}
			if (closestMineral!=NULL)
			  unit->rightClick(closestMineral);
		}
		inRange = false;
		for(std::set<Unit*>::const_iterator e=Broodwar->enemy()->getUnits().begin();e!=Broodwar->enemy()->getUnits().end();e++){
			if ((*e)->getHitPoints()>0 && (*e)->getDistance(unit->getPosition())<(5*32))
				inRange = true;
		}
		if(unit->getHitPoints()<40 && inRange && !unit->isBurrowed()){
			  unit->burrow();
			  HuntersMark = unit->getPosition();
		}
		if(!inRange && unit->isBurrowed())
			  unit->unburrow();
		
	}
	void armyZergling(BWAPI::Game *Broodwar, BWAPI::Unit* unit)
	{
		if(unit->getOrder()==Orders::PlayerGuard)
						unit->attack(Position(rand()%Broodwar->mapWidth()*32, rand()%Broodwar->mapHeight()*32));
				
					if(shouldBurrow(unit) && !(unit->isBurrowed()))
						  unit->burrow();
					if(!shouldBurrow(unit) && unit->isBurrowed())
						  unit->unburrow();
	}
	
	void armyBroodling(BWAPI::Game *Broodwar, BWAPI::Unit* unit)
	{
		if(unit->getOrder()==Orders::PlayerGuard)
			unit->attack(Position(rand()%Broodwar->mapWidth()*32, rand()%Broodwar->mapHeight()*32));
	}

	void armyHydralisk(BWAPI::Game *Broodwar, BWAPI::Unit* unit)
	{
		//if(unit->getHitPoints()<30 && !unit->isBurrowed())
		//	  unit->burrow();
		if(unit->getHitPoints()>=40 && unit->isBurrowed())
			  unit->unburrow();
		if(unit->getOrder()==Orders::PlayerGuard && searching)
			unit->attack(Position(rand()%Broodwar->mapWidth()*32, rand()%Broodwar->mapHeight()*32));
		if((!unit->isAttacking()) && hcount / 4 > lucount)
			unit->morph(UnitTypes::Zerg_Lurker);
	}

	void armyLurker(BWAPI::Game *Broodwar, BWAPI::Unit* unit)
	{
	  inRange = false;
	  for(std::set<Unit*>::const_iterator e=Broodwar->enemy()->getUnits().begin();e!=Broodwar->enemy()->getUnits().end();e++){
		  if ((*e)->getHitPoints()>0 && (*e)->getDistance(unit->getPosition())<(6*32))
			inRange = true;
	  }
	  if(inRange && !unit->isBurrowed())
		  unit->burrow();
	  if(!inRange && unit->isBurrowed())
		  unit->unburrow();
	}

	void armyColony(BWAPI::Game *Broodwar, BWAPI::Unit* unit)
	{
			unit->morph(UnitTypes::Zerg_Sunken_Colony);
	}

	void armyScourge(BWAPI::Game *Broodwar, BWAPI::Unit* unit)
	{
	  SniperTarget = NULL;
	  for(std::set<Unit*>::const_iterator e=Broodwar->enemy()->getUnits().begin();e!=Broodwar->enemy()->getUnits().end();e++){
		  if ((*e)->getHitPoints()>0 && (*e)->getDistance(unit->getPosition())<(11*32) && (*e)->getType().isFlyer())
		  {
			  unit->attack((*e));
		  }
	  }

	}

	void armyMutalisk(BWAPI::Game *Broodwar, BWAPI::Unit* unit)
	{
	  SniperTarget = NULL;
	  for(std::set<Unit*>::const_iterator e=Broodwar->enemy()->getUnits().begin();e!=Broodwar->enemy()->getUnits().end();e++){
		  if ((*e)->getHitPoints()>0 && (*e)->getDistance(unit->getPosition())<(11*32) && (*e)->getType()==UnitTypes::Terran_Siege_Tank_Siege_Mode)
		  {
			inRange = true;
			SniperTarget = (*e);
		  }
	  }
	}

	void armyCounter(BWAPI::Game *Broodwar)
	{
		pacer ++;	
		//track how much time has passed
		
		//counter
		wcount = 0;
		gassers = 0;
		lgassers = 0;
		eggcount = 0;
		spcount = 0;
		excount = 0;
		hcount = 0;
		zcount = 0;
		lucount = 0;
		lcount = 0;
		spccount = 0;
		sccount = 0;
		hacount = 0;
		mcount = 0;
		spicount = 0;
		qcount = 0;
		quncount = 0;
		ax = 0;
		ay = 0;

		for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
		{
			if((*i)->getType().isWorker())
				wcount ++;
			if ((*i)->isGatheringGas()){
				gassers ++;
				if((*i)->getDistance(Position(Broodwar->self()->getStartLocation()))<300)
					lgassers ++;
			}	
			if((*i)->getType()==UnitTypes::Zerg_Egg)
				eggcount ++;
			if((*i)->getType()==UnitTypes::Zerg_Spawning_Pool)
				spcount ++;
			if((*i)->getType()==UnitTypes::Zerg_Spawning_Pool && !((*i)->isBeingConstructed()))
				spccount ++;
			
			if((*i)->getType()==UnitTypes::Zerg_Extractor && !((*i)->isBeingConstructed())){
				excount ++;
				if((*i)->getDistance(Position(Broodwar->self()->getStartLocation()))>300)
					extractor2 = (*i);
				else
					extractor = (*i);
			}
			if((*i)->getType()==UnitTypes::Zerg_Hydralisk && !((*i)->isBurrowed()))
				hcount ++;
			if((*i)->getType()==UnitTypes::Zerg_Zergling)
				zcount ++;
			if((*i)->getType()==UnitTypes::Zerg_Lair)
				lcount ++;
			if((*i)->getType()==UnitTypes::Zerg_Lurker)
				lucount ++;
			if((*i)->getType()==UnitTypes::Zerg_Sunken_Colony)
				sccount ++;
			if((*i)->getType().isResourceDepot() && !((*i)->isBeingConstructed()))
				hacount ++;
			if((*i)->getType()==UnitTypes::Zerg_Mutalisk)
				mcount ++;
			if((*i)->getType()==UnitTypes::Zerg_Spire)
				spicount ++;
			if((*i)->getType()==UnitTypes::Zerg_Queens_Nest)
				quncount ++;
			if((*i)->getType()==UnitTypes::Zerg_Queen)
				qcount ++;
			if((*i)->getType()==UnitTypes::Zerg_Scourge)
				scocount ++;
		}
		if(zcount >= 6)
			rushed = true;
	}
	void findTargets()
	{
		int distance = 0;
		int mindist = 9999999999;

		if(hcount==0){
			HunterKiller = Position(Broodwar->self()->getStartLocation());
			SafeSpot = Position(Broodwar->self()->getStartLocation());
			OnDeck = Position(Broodwar->self()->getStartLocation());
		}

		for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
		{		
			//gather around Hydralisk closest all other hydralisks
		
			if ((*i)->getType()==UnitTypes::Zerg_Hydralisk || (*i)->getType()==UnitTypes::Zerg_Lurker){
				distance = 0;
				for(std::set<Unit*>::const_iterator h=Broodwar->self()->getUnits().begin();h!=Broodwar->self()->getUnits().end();h++)
				{
					if ((*i)->getType()==UnitTypes::Zerg_Hydralisk || (*i)->getType()==UnitTypes::Zerg_Lurker)
						distance += (*i)->getDistance((*h)->getPosition());
				}
				if(mindist>distance){
					SafeSpot = (*i)->getPosition();
					mindist = distance;
				}
			}


			//gather around Hydralisk closest to the target
		
			if ((*i)->getType()==UnitTypes::Zerg_Hydralisk){
				distance = (*i)->getDistance(HuntersMark);
				
				if(mindist>distance){
					HunterKiller = (*i)->getPosition();
					mindist = distance;
				}
			}
		}

		int halfX = (HunterKiller.x() + Position(Broodwar->self()->getStartLocation()).x())/2;
		int halfY = (HunterKiller.y() + Position(Broodwar->self()->getStartLocation()).y())/2;
		OnDeck = Position(halfX, halfY);
	}
	void overlordRoles()
	{
		mindist = 999999999;
		if(DetectorMain==NULL || DetectorMain->getHitPoints()<=100){
			for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
			{
				if((*i)->getHitPoints()>100 && (*i)->getType()==UnitTypes::Zerg_Overlord && !((*i)->isBlind())){
					distance = (*i)->getDistance(HunterKiller);
					if(mindist>distance){
						DetectorMain = (*i);
						mindist = distance;
					}
				}
			}
		}
		mindist = 999999999;
		if(DetectorSafe==NULL || DetectorSafe->getHitPoints()<=100){
			for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
			{
				if((*i)->getHitPoints()>100 && (*i)->getType()==UnitTypes::Zerg_Overlord && !((*i)->isBlind())){
					distance = (*i)->getDistance(SafeSpot);
					if(mindist>distance){
						DetectorSafe = (*i);
						mindist = distance;
					}
				}
			}
		}
		mindist = 999999999;
		if(DetectorReserve==NULL || DetectorReserve->getHitPoints()<=100){
			for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
			{
				if((*i)->getHitPoints()>100 && (*i)->getType()==UnitTypes::Zerg_Overlord && !((*i)->isBlind()) && (*i)!=DetectorMain){
					distance = (*i)->getDistance(OnDeck);
					if(mindist>distance){
						DetectorReserve = (*i);
						mindist = distance;
					}
				}
			}
		}
		
		if(aggression)
			DetectorMain->move(HunterKiller);
		else
			DetectorMain->move(SafeSpot);
		DetectorSafe->move(SafeSpot);
		DetectorReserve->move(OnDeck);
	}

	void gatherFlyers()
	{
		if(pacer%100==0 && hasInfantry){
			for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
			{
				if((*i)->getType()==UnitTypes::Zerg_Mutalisk){
					if(SniperTarget == NULL){
						(*i)->attack(SafeSpot);
					}
					else{
						(*i)->attack(SniperTarget);
					}
				}
				if((*i)->getType()==UnitTypes::Zerg_Queen){
					if ((*i)->getEnergy() > 142)
						(*i)->move(HunterKiller);
					else
						(*i)->move(Position(Broodwar->self()->getStartLocation()));
				}
			}
		}
	}
	
	void gatherInfantry()
	{
		if((pacer % 100==0 && (pacer/100)%2==0 && !searching))
		{
			for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
			{
				if((TargetEnemy->getDistance(Position(Broodwar->self()->getStartLocation()))>1000))
				{
					if ((*i)->getType()==UnitTypes::Zerg_Hydralisk && !((*i)->isAttacking()))
					{
						if(aggression)
							(*i)->attack(HunterKiller);
						else
							(*i)->attack(SafeSpot);
					}
					if ((*i)->getType()==UnitTypes::Zerg_Lurker && !((*i)->isBurrowed()))
					{
						if(aggression)
							(*i)->move(HunterKiller);
						else
							(*i)->move(SafeSpot);
					}
				}
			}
		}
	}
	void moveArmy()
	{
		if(!searching && pacer % 100==0 && (pacer/100)%2==1 && HuntersMark.x()!=-1 && (aggression) || TargetEnemy->getDistance(Position(Broodwar->self()->getStartLocation()))<1000){
			for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
			{
				if ((*i)->getType()==UnitTypes::Zerg_Hydralisk){
					(*i)->attack(HuntersMark);
				}
				if ((*i)->getType()==UnitTypes::Zerg_Lurker && (*i)->isIdle()){
					(*i)->move(HuntersMark);
				}
			}
		}
	}
	
	void drawCircles()
	{
		//HunterKiller circle
		Broodwar->drawCircleMap(HunterKiller.x(),HunterKiller.y(),10,Colors::Blue);
		//SafeSpot circle
		Broodwar->drawCircleMap(SafeSpot.x(),SafeSpot.y(),20,Colors::Green);
		//HuntersMark circle
		Broodwar->drawCircleMap(HuntersMark.x(),HuntersMark.y(),10,Colors::Red);
	}

	void circleOverlords(BWAPI::Unit* unit)
	{
		if(pacer % 10 == 1 && (unit->getType()==UnitTypes::Zerg_Overlord && unit!=DetectorMain && unit!=DetectorReserve)){
			double ydiff = (unit->getPosition().y() - Position(Broodwar->self()->getStartLocation()).y());
			double xdiff = (unit->getPosition().x() - Position(Broodwar->self()->getStartLocation()).x());
			double angle = 1;

			if(ydiff!=0 && xdiff!=0)
				angle = atan2(ydiff, xdiff);


			int startX = Position(Broodwar->self()->getStartLocation()).x();

			int startY = Position(Broodwar->self()->getStartLocation()).y();

			int carrotX = (int)(5*32*cos(angle+.5))+startX;

			int carrotY = (int)(5*32*sin(angle+.5))+startY;

			unit->move(Position(carrotX, carrotY));
		}
	}

	void circleScourge(BWAPI::Unit* unit)
	{
		if(pacer % 10 == 2 && unit->getType()==UnitTypes::Zerg_Scourge){
			double ydiff = (unit->getPosition().y() - Position(Broodwar->self()->getStartLocation()).y());

			double xdiff = (unit->getPosition().x() - Position(Broodwar->self()->getStartLocation()).x());
			double angle = 1;

			if(ydiff!=0 && xdiff!=0)
				angle = atan2(ydiff, xdiff);


			int startX = Position(Broodwar->self()->getStartLocation()).x();

			int startY = Position(Broodwar->self()->getStartLocation()).y();

			int carrotX = (int)(10*32*cos(angle-.8))+startX;

			int carrotY = (int)(10*32*sin(angle-.8))+startY;

			unit->patrol(Position(carrotX, carrotY));
		}
	}

	void setFlags()
	{
		aggression = false;
		if((hcount + lucount) > 14)
			aggression = true;
		searching = false;
		if((hcount + lucount) > 60)
			searching = true;
		hasInfantry = false;
		if((hcount + lucount) > 0)
			hasInfantry = true;
	}

	void workerDefender()
	{
		hatcheryPosition = Position(Broodwar->self()->getStartLocation());
		if(defenseOne == -1 || defenseTwo == -1)
		{
			for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
			{
				if((*i)->getType().isWorker() && (*i)->isGatheringMinerals() && defenseOne == -1)
				{
					defenseOne = (*i)->getID();
				}
			
				if((*i)->getType().isWorker() && (*i)->isGatheringMinerals() && defenseTwo == -1)
				{
					defenseTwo = (*i)->getID();
				}
			}
		}

		//scan for all visible units; only target those within range, are workers, and are enemies

		for(std::set<Unit*>::const_iterator i=Broodwar->getAllUnits().begin();i!=Broodwar->getAllUnits().end();i++)
		{
			if((*i)->getType().isWorker() && (*i)->getPlayer()==Broodwar->enemy() && (*i)->getDistance(hatcheryPosition) <= baseRange)
			{
				//find our two defense drones, attack the enemy

				for(std::set<Unit*>::const_iterator j=Broodwar->self()->getUnits().begin();j!=Broodwar->self()->getUnits().end();j++)
				{
					if((*j)->getID() == defenseOne || (*j)->getID() == defenseTwo)
					{
						(*j)->attack((*i));
					}
				}
			}
		}
	}

	void build()
	{
		for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
		{
			if((*i)->getType().isWorker()  && Broodwar->self()->minerals()>125){
				(*i)->build(buildsp, UnitTypes::Zerg_Spawning_Pool);
				
				if(spcount>0 && rushed){
					(*i)->build(buildcc1, UnitTypes::Zerg_Creep_Colony);
					(*i)->build(buildcc2, UnitTypes::Zerg_Creep_Colony);
					(*i)->build(buildcc3, UnitTypes::Zerg_Creep_Colony);
					(*i)->build(buildcc4, UnitTypes::Zerg_Creep_Colony);
					(*i)->build(buildcc5, UnitTypes::Zerg_Creep_Colony);

					(*i)->build(buildha1, UnitTypes::Zerg_Hatchery);
					(*i)->build(buildhd, UnitTypes::Zerg_Hydralisk_Den);
					(*i)->build(buildex, UnitTypes::Zerg_Extractor);
					if(Broodwar->enemy()->getRace()!=Races::Zerg)
						(*i)->build(buildqu, UnitTypes::Zerg_Queens_Nest);

				}
				if(aggression){
					(*i)->build(buildha2, UnitTypes::Zerg_Hatchery);
					(*i)->build(buildha3, UnitTypes::Zerg_Hatchery);
				}
				if(hacount>=3){
					(*i)->build(buildex2, UnitTypes::Zerg_Extractor);
				}
				
				break;
			}
		}
	}

	void armyBase(BWAPI::Game *Broodwar, BWAPI::Unit* unit)
	{
	  unit->research(TechTypes::Burrowing);
	  if(lcount < 1 && !(unit->isBeingConstructed()))
	  {
		  unit->morph(UnitTypes::Zerg_Lair);
		  lcount ++;
	  }
	  
	  unit->upgrade(UpgradeTypes::Pneumatized_Carapace);
	  std::set<Unit*> myLarva=unit->getLarva();
	  if (myLarva.size()>0)
	  {
			Unit* larva=*myLarva.begin();
			//If supply is almost capped then make Overlords
			if (Broodwar->self()->supplyTotal() - Broodwar->self()->supplyUsed() <=4){
				if((spcount>=1 && eggcount<1) || Broodwar->self()->supplyTotal() == 0 && pacer%30==3)
					larva->morph(UnitTypes::Zerg_Overlord);
			}
			if (wcount < 20 && !(wcount==9&&!rushed)){
				larva->morph(UnitTypes::Zerg_Drone);
			}
			if (wcount < 40 && hacount>=4){
				larva->morph(UnitTypes::Zerg_Drone);
			}
			if ((wcount >= 20 && zcount < 6) || (wcount ==9 && !rushed))
				larva->morph(UnitTypes::Zerg_Zergling);
			if (wcount >= 20 && qcount < hcount/4)
				larva->morph(UnitTypes::Zerg_Queen);
			if (wcount >= 20 && sccount < hcount/3)
				larva->morph(UnitTypes::Zerg_Scourge);
			if(wcount >= 20 && Broodwar->self()->gas()>200 && Broodwar->self()->minerals()>300)
				larva->morph(UnitTypes::Zerg_Hydralisk);
	  }
	}
	
	bool gasBreak(BWAPI::Unit* unit)
	{
		if(pacer%10==0)
		{
			if (unit->getType().isWorker() && unit->getOrder()==Orders::MiningMinerals && lgassers < 3 && excount>0)
			{
				  unit->rightClick(extractor);
				  lgassers ++;
				  return true;
			}
		
			if (unit->getType().isWorker() && unit->getOrder()==Orders::MiningMinerals && gassers < 6 && excount>1)
			{
				  unit->rightClick(extractor2);
				  return true;
			}
		}
		return false;
	}

	void armyHydraliskDen(BWAPI::Unit* unit)
	{
		if(aggression)
		{
			unit->research(TechTypes::Lurker_Aspect);
			unit->upgrade(UpgradeTypes::Muscular_Augments);
			unit->upgrade(UpgradeTypes::Grooved_Spines);
		}
	}

	void armyQueensNest(BWAPI::Unit* unit)
	{
		if(aggression)
		{
			if(Broodwar->enemy()->getRace()==Races::Zerg)
				unit->research(TechTypes::Ensnare);
			else
				unit->research(TechTypes::Spawn_Broodlings);
		}
	}

	void armyQueen(BWAPI::Unit* unit)
	{
		for(std::set<Unit*>::const_iterator j=Broodwar->enemy()->getUnits().begin();j!=Broodwar->enemy()->getUnits().end();j++)
		{
			if ((*j)->getType().airWeapon().targetsAir()
				/*&& (pacer%5 == 0)*/
				&& unit->getDistance((*j)->getPosition()) <  (8*32) 
				&& unit->getOrder() != Orders::CastSpawnBroodlings)
			{
				int x = 64;
				// coordinate assignments
				std::vector<BWAPI::Position> points;
				Position p1(x, 0);		// E
				points.push_back(p1);
				Position p2(x, -x);		// NE
				points.push_back(p2);
				Position p3(0, -x);		// N
				points.push_back(p3);
				Position p4(-x, -x);	// NW
				points.push_back(p4);
				Position p5(-x, 0);		// W
				points.push_back(p5);
				Position p6(-x, x);		// SW
				points.push_back(p6);
				Position p7(0, x);		// S
				points.push_back(p7);
				Position p8(x, x);		// SE
				points.push_back(p8);
	
				for(std::set<Unit*>::const_iterator d=Broodwar->enemy()->getUnits().begin();d!=Broodwar->enemy()->getUnits().end();d++)
				{
					if ((*d)->getType().airWeapon().targetsAir()
						/*&& pacer%5 == 0)*/
						&& unit->getDistance((*d)->getPosition()) <  (8*32)) 
					{
							totalDist += unit->getDistance((*d)->getPosition());
					}
				}
				Position temp;
				temp = Position(0,0);
				for (std::vector<BWAPI::Position>::const_iterator k = points.begin(); k != points.end(); k++)
				{
					if((*k).getDistance((*j)->getPosition()) > temp.getDistance((*j)->getPosition()) &&
					   (*k).getDistance((*j)->getPosition()) > totalDist)
					{
							temp = (*k);
					}
				}
				if (unit->getEnergy() > 142)
				{
					unit->move(unit->getPosition() + temp);
				}
				totalDist = 0;
			}
		   
			if (shouldBrood((*j)))
			   {
				   brooding = false;
				   for(std::set<Unit*>::const_iterator q=Broodwar->self()->getUnits().begin();q!=Broodwar->self()->getUnits().end();q++){
					   if ((*q)->getType()==UnitTypes::Zerg_Queen && (*q)->getOrder()==Orders::CastSpawnBroodlings)
						   brooding = true;
				   }
				   if(!brooding && unit->getEnergy()>=150)
						unit->useTech(TechTypes::Spawn_Broodlings, (*j));
			   }
			   int neighbors = 0;
			   if ((*j)->getDistance(unit->getPosition())<32*11 && !((*j)->isEnsnared())){
					for(std::set<Unit*>::const_iterator k=Broodwar->enemy()->getUnits().begin();k!=Broodwar->enemy()->getUnits().end();k++)
					{
						if ((*j)->getDistance((*k)->getPosition())<32*2 && !((*k)->isEnsnared()))
							neighbors ++;
					}
					if(neighbors >= 5 && unit->getEnergy() >= 200 && pacer % 10 == 0){
						unit->useTech(TechTypes::Ensnare, (*j)->getPosition());
						break;
					}
			   }	
		  }
	}

	void assignMap()
	{
		twoPlayers = false;
		top=false;
		left=false;
		if(Broodwar->self()->getStartLocation().y() < Broodwar->mapHeight()/2)
			top=true;
		if(Broodwar->self()->getStartLocation().x() < Broodwar->mapWidth()/2)
			left=true;

		//destination
		if(Broodwar->mapHash()=="4e24f217d2fe4dbfa6799bc57f74d8dc939d425b")
		{
			twoPlayers = true;
			if(top)
			{
				buildsp=TilePosition(31,12);
				buildcc1=TilePosition(36,8);
				buildcc2=TilePosition(40,9);
				buildcc3=TilePosition(40,11);
				buildcc4=TilePosition(40, 7);
				buildcc5=TilePosition(34,10);
				buildex=TilePosition(31,2);
				buildhd=TilePosition(36,4);
				buildha1=TilePosition(34,12);
				buildha3=TilePosition(39,13);
				buildha2=TilePosition(63,19);
				buildex2=TilePosition(70,22);
				buildqu = TilePosition(35,2);
			}
			if(!top)
			{
				buildsp=TilePosition(64,123);
				buildcc1=TilePosition(63,116);
				buildcc2=TilePosition(63,121);
				buildcc3=TilePosition(61,117);
				buildcc4=TilePosition(61,119);
				buildcc5=TilePosition(59,118);
				buildex=TilePosition(64,113);
				buildhd=TilePosition(60,115);
				buildha1=TilePosition(60,123);
				buildha2=TilePosition(29,107);
				buildha3=TilePosition(56,123);
				buildex2=TilePosition(22,106);
				buildqu = TilePosition(68,113);
			}
		}
		//benzene
		if(Broodwar->mapHash()=="af618ea3ed8a8926ca7b17619eebcb9126f0d8b1")
		{
			twoPlayers = true;
			if(top)
			{
				buildsp=TilePosition(112,14);
				buildcc1=TilePosition(113,116);
				buildcc2=TilePosition(113,118);
				buildcc3=TilePosition(113,120);
				buildcc4=TilePosition(122,116);
				buildcc5=TilePosition(111,118);
				buildex=TilePosition(117,8);
				buildhd=TilePosition(113,11);
				buildha1=TilePosition(116,17);
				buildha2=TilePosition(113,40);
				buildha3=TilePosition(116,20);
				buildex2=TilePosition(113,35);
				buildqu = TilePosition(113,8);
			}
			if(!top)
			{
				buildsp=TilePosition(9,99);
				buildcc1=TilePosition(13,96);
				buildcc2=TilePosition(15,96);
				buildcc3=TilePosition(13,98);
				buildcc4=TilePosition(15,98);
				buildcc5=TilePosition(6,102);
				buildex=TilePosition(7,91);
				buildhd=TilePosition(11,94);
				buildqu = TilePosition(11,92);
				buildha1=TilePosition(9,102);
				buildha3=TilePosition(13,102);
				buildha2=TilePosition(11,70);
				buildex2=TilePosition(11,76);
				
			}
		}
		//andromeda
		if(Broodwar->mapHash()=="1e983eb6bcfa02ef7d75bd572cb59ad3aab49285")
		{
			if(top && left)
			{
				buildsp=TilePosition(12,3);
				buildcc1=TilePosition(0,4);
				buildcc2=TilePosition(5,14);
				buildcc3=TilePosition(7,14);
				buildcc4=TilePosition(5,16);
				buildcc5=TilePosition(7,16);
				buildex=TilePosition(7,1);
				buildhd=TilePosition(16,8);
				buildqu = TilePosition(16,6);
				buildha1=TilePosition(8,10);
				buildha3=TilePosition(12,10);
				buildha2=TilePosition(21,21);
				buildex2=TilePosition(28,22);
			}
			if(top && !left)
			{
				buildsp=TilePosition(113,3);
				buildcc1=TilePosition(126,9);
				buildcc2=TilePosition(118,13);
				buildcc3=TilePosition(120,13);
				buildcc4=TilePosition(118,15);
				buildcc5=TilePosition(120,15);
				buildex=TilePosition(117,2);
				buildhd=TilePosition(109,6);
				buildqu = TilePosition(109,4);
				buildha1=TilePosition(108,9);
				buildha3=TilePosition(112,9);
				buildha2=TilePosition(103,21);
				buildex2=TilePosition(96,22);
			}
			if(!top && left)
			{
				buildsp=TilePosition(13,116);
				buildcc1=TilePosition(5,125);
				buildcc2=TilePosition(6,111);
				buildcc3=TilePosition(5,113);
				buildcc4=TilePosition(10,111);
				buildcc5=TilePosition(11,113);
				buildex=TilePosition(7,113);
				buildhd=TilePosition(16,116);
				buildqu = TilePosition(16,118);
				buildha1=TilePosition(9,122);
				buildha3=TilePosition(13,122);
				buildha2=TilePosition(21,105);
				buildex2=TilePosition(28,105);
			}
			if(!top && !left)
			{
				buildsp=TilePosition(112,116);
				buildcc1=TilePosition(126,122);
				buildcc2=TilePosition(115,114);
				buildcc3=TilePosition(116,112);
				buildcc4=TilePosition(121,112);
				buildcc5=TilePosition(121,114);
				buildex=TilePosition(117,114);
				buildhd=TilePosition(109,118);
				buildqu = TilePosition(109,116);
				buildha1=TilePosition(110,122);
				buildha3=TilePosition(114,122);
				buildha2=TilePosition(103,105);
				buildex2=TilePosition(96,105);
			}
		}
		//Aztec
		if(Broodwar->mapHash()=="ba2fc0ed637e4ec91cc70424335b3c13e131b75a")
		{
			if(top)
			{
				buildsp=TilePosition(72,9);
				buildcc1=TilePosition(67,12);
				buildcc2=TilePosition(77,4);
				buildcc3=TilePosition(77,6);
				buildcc4=TilePosition(77,8);
				buildcc5=TilePosition(77,10);
				buildex=TilePosition(68,1);
				buildhd=TilePosition(73,4);
				buildqu = TilePosition(73,1);
				buildha1=TilePosition(71,11);
				buildha3=TilePosition(71,14);
				buildha2=TilePosition(99,5);
				buildex2=TilePosition(106,6);
			}
			if(!top && left)
			{
				buildsp=TilePosition(8,87);
				buildcc1=TilePosition(5,78);
				buildcc2=TilePosition(11,79);
				buildcc3=TilePosition(13,80);
				buildcc4=TilePosition(15,80);
				buildcc5=TilePosition(13,82);
				buildex=TilePosition(7,78);
				buildhd=TilePosition(10,81);
				buildqu = TilePosition(15,82);
				buildha1=TilePosition(11,86);
				buildha3=TilePosition(15,86);
				buildha2=TilePosition(6,56);
				buildex2=TilePosition(6,51);
			}
			if(!top && !left)
			{
				buildsp=TilePosition(113,102);
				buildcc1=TilePosition(120,105);
				buildcc2=TilePosition(118,105);
				buildcc3=TilePosition(116,105);
				buildcc4=TilePosition(114,105);
				buildcc5=TilePosition(112,105);
				buildex=TilePosition(117,95);
				buildhd=TilePosition(113,97);
				buildqu = TilePosition(113,100);
				buildha1=TilePosition(109,98);
				buildha3=TilePosition(109,101);
				buildha2=TilePosition(98,119);
				buildex2=TilePosition(91,120);
			}
		}
		//Circuit Breaker
		if(Broodwar->mapHash()=="450a792de0e544b51af5de578061cb8a2f020f32")
		{
			if(top && left)
			{
				buildsp=TilePosition(13,6);
				buildcc1=TilePosition(7,15);
				buildcc2=TilePosition(9,15);
				buildcc3=TilePosition(11,15);
				buildcc4=TilePosition(7,17);
				buildcc5=TilePosition(9,17);
				buildex=TilePosition(7,4);
				buildhd=TilePosition(13,8);
				buildqu = TilePosition(13,10);
				buildha1=TilePosition(18,6);
				buildha3=TilePosition(18,9);
				buildha2=TilePosition(7,34);
				buildex2=TilePosition(9,40);
			}
			if(top && !left)
			{
				buildsp=TilePosition(110,7);
				buildcc1=TilePosition(116,15);
				buildcc2=TilePosition(118,15);
				buildcc3=TilePosition(120,15);
				buildcc4=TilePosition(118,17);
				buildcc5=TilePosition(120,17);
				buildex=TilePosition(116,4);
				buildhd=TilePosition(110,9);
				buildqu = TilePosition(110,11);
				buildha1=TilePosition(105,6);
				buildha3=TilePosition(105,9);
				buildha2=TilePosition(117,34);
				buildex2=TilePosition(115,40);
			}
			if(!top && left)
			{
				buildsp=TilePosition(11,123);
				buildcc1=TilePosition(3,114);
				buildcc2=TilePosition(12,114);
				buildcc3=TilePosition(12,112);
				buildcc4=TilePosition(14,114);
				buildcc5=TilePosition(14,112);
				buildex=TilePosition(7,113);
				buildhd=TilePosition(14,122);
				buildqu = TilePosition(14,120);
				buildha1=TilePosition(18,112);
				buildha3=TilePosition(18,115);
				buildha2=TilePosition(7,92);
				buildex2=TilePosition(9,87);
			}
			if(!top && !left)
			{
				buildsp=TilePosition(119,124);
				buildcc1=TilePosition(122,112);
				buildcc2=TilePosition(114,114);
				buildcc3=TilePosition(112,114);
				buildcc4=TilePosition(114,112);
				buildcc5=TilePosition(112,112);
				buildex=TilePosition(117,113);
				buildhd=TilePosition(116,124);
				buildqu = TilePosition(116,122);
				buildha1=TilePosition(106,115);
				buildha3=TilePosition(106,118);
				buildha2=TilePosition(117,92);
				buildex2=TilePosition(115,87);
			}
		}
		//Fortress
		if(Broodwar->mapHash()=="83320e505f35c65324e93510ce2eafbaa71c9aa1")
		{
			if(top && left)
			{
				buildsp=TilePosition(49,13);
				buildcc1=TilePosition(41,7);
				buildcc2=TilePosition(58,5);
				buildcc3=TilePosition(60,5);
				buildcc4=TilePosition(58,7);
				buildcc5=TilePosition(60,7);
				buildex=TilePosition(49,2);
				buildhd=TilePosition(53,1);
				buildqu = TilePosition(53,3);
				buildha1=TilePosition(50,15);
				buildha3=TilePosition(54,15);
				buildha2=TilePosition(81,7);
				buildex2=TilePosition(81,2);
			}
			if(!top && left)
			{
				buildsp=TilePosition(8,80);
				buildcc1=TilePosition(0,73);
				buildcc2=TilePosition(11,70);
				buildcc3=TilePosition(13,70);
				buildcc4=TilePosition(11,68);
				buildcc5=TilePosition(13,68);
				buildex=TilePosition(7,69);
				buildhd=TilePosition(2,67);
				buildqu = TilePosition(2,69);
				buildha1=TilePosition(14,77);
				buildha3=TilePosition(18,77);
				buildha2=TilePosition(9,49);
				buildex2=TilePosition(2,50);
			}
			if(top && !left)
			{
				buildsp=TilePosition(113,50);
				buildcc1=TilePosition(126,58);
				buildcc2=TilePosition(117,60);
				buildcc3=TilePosition(119,60);
				buildcc4=TilePosition(117,62);
				buildcc5=TilePosition(119,62);
				buildex=TilePosition(117,49);
				buildhd=TilePosition(113,52);
				buildqu = TilePosition(113,54);
				buildha1=TilePosition(108,56);
				buildha3=TilePosition(108,59);
				buildha2=TilePosition(115,78);
				buildex2=TilePosition(122,78);
			}
			if(!top && !left)
			{
				buildsp=TilePosition(79,125);
				buildcc1=TilePosition(87,119);
				buildcc2=TilePosition(69,118);
				buildcc3=TilePosition(69,120);
				buildcc4=TilePosition(67,118);
				buildcc5=TilePosition(67,120);
				buildex=TilePosition(77,114);
				buildhd=TilePosition(76,125);
				buildqu = TilePosition(76,123);
				buildha1=TilePosition(66,111);
				buildha3=TilePosition(70,111);
				buildha2=TilePosition(43,118);
				buildex2=TilePosition(43,124);
			}
		}
		//Heartbreak Ridge
		if(Broodwar->mapHash()=="6f8da3c3cc8d08d9cf882700efa049280aedca8c")
		{
			twoPlayers = true;
			if(left)
			{
				buildsp=TilePosition(11,40);
				buildcc1=TilePosition(5,42);
				buildcc2=TilePosition(13,37);
				buildcc3=TilePosition(7,42);
				buildcc4=TilePosition(9,42);
				buildcc5=TilePosition(11,42);
				buildex=TilePosition(7,32);
				buildhd=TilePosition(12,35);
				buildqu = TilePosition(11,32);
				buildha1=TilePosition(15,41);
				buildha3=TilePosition(16,38);
				buildha2=TilePosition(13,66);
				buildex2=TilePosition(14,72);
			}
			if(!left)
			{
				buildsp=TilePosition(114,59);
				buildcc1=TilePosition(121,51);
				buildcc2=TilePosition(111,52);
				buildcc3=TilePosition(113,52);
				buildcc4=TilePosition(115,52);
				buildcc5=TilePosition(113,54);
				buildex=TilePosition(117,51);
				buildhd=TilePosition(117,60);
				buildqu = TilePosition(120,60);
				buildha1=TilePosition(110,58);
				buildha3=TilePosition(106,58);
				buildha2=TilePosition(111,28);
				buildex2=TilePosition(110,23);
			}
		}
		//Tau Cross
		if(Broodwar->mapHash()=="9bfc271360fa5bab3707a29e1326b84d0ff58911")
		{
			if(left)
			{
				buildsp=TilePosition(11,46);
				buildcc1=TilePosition(5,39);
				buildcc2=TilePosition(11,40);
				buildcc3=TilePosition(13,40);
				buildcc4=TilePosition(15,41);
				buildcc5=TilePosition(8,49);
				buildex=TilePosition(7,39);
				buildhd=TilePosition(11,42);
				buildqu = TilePosition(15,43);
				buildha1=TilePosition(10,48);
				buildha3=TilePosition(14,48);
				buildha2=TilePosition(14,13);
				buildex2=TilePosition(11,8);
			}
			if(top && !left)
			{
				buildsp=TilePosition(113,11);
				buildcc1=TilePosition(120,15);
				buildcc2=TilePosition(118,15);
				buildcc3=TilePosition(116,15);
				buildcc4=TilePosition(114,15);
				buildcc5=TilePosition(121,5);
				buildex=TilePosition(117,4);
				buildhd=TilePosition(113,7);
				buildqu = TilePosition(113,9);
				buildha1=TilePosition(110,14);
				buildha3=TilePosition(115,17);
				buildha2=TilePosition(103,37);
				buildex2=TilePosition(96,35);
			}
			if(!top && !left)
			{
				buildsp=TilePosition(90,121);
				buildcc1=TilePosition(95,123);
				buildcc2=TilePosition(86,116);
				buildcc3=TilePosition(88,116);
				buildcc4=TilePosition(86,120);
				buildcc5=TilePosition(88,120);
				buildex=TilePosition(86,118);
				buildhd=TilePosition(90,116);
				buildqu = TilePosition(97,113);
				buildha1=TilePosition(86,112);
				buildha3=TilePosition(90,112);
				buildha2=TilePosition(51,113);
				buildex2=TilePosition(44,115);
			}
		}
		//Python
		if(Broodwar->mapHash()=="de2ada75fbc741cfa261ee467bf6416b10f9e301")
		{
			if(Broodwar->self()->getStartLocation()==TilePosition(83,6))
			{
				buildsp=TilePosition(80,8);
				buildcc1=TilePosition(86,11);
				buildcc2=TilePosition(77,8);
				buildcc3=TilePosition(77,6);
				buildcc4=TilePosition(77,4);
				buildcc5=TilePosition(81,1);
				buildex=TilePosition(83,1);
				buildhd=TilePosition(79,4);
				buildqu = TilePosition(77,2);
				buildha1=TilePosition(78,12);
				buildha3=TilePosition(82,12);
				buildha2=TilePosition(47,6);
				buildex2=TilePosition(40,5);
			}
			if(Broodwar->self()->getStartLocation()==TilePosition(117,40))
			{
				buildsp=TilePosition(113,38);
				buildcc1=TilePosition(126,39);
				buildcc2=TilePosition(114,44);
				buildcc3=TilePosition(116,46);
				buildcc4=TilePosition(118,46);
				buildcc5=TilePosition(120,46);
				buildex=TilePosition(117,35);
				buildhd=TilePosition(113,40);
				buildqu = TilePosition(113,36);
				buildha1=TilePosition(109,35);
				buildha3=TilePosition(109,39);
				buildha2=TilePosition(117,66);
				buildex2=TilePosition(118,72);
			}
			if(Broodwar->self()->getStartLocation()==TilePosition(42,119))
			{
				buildsp=TilePosition(45,122);
				buildcc1=TilePosition(35,118);
				buildcc2=TilePosition(51,123);
				buildcc3=TilePosition(51,121);
				buildcc4=TilePosition(51,119);
				buildcc5=TilePosition(51,117);
				buildex=TilePosition(42,114);
				buildhd=TilePosition(33,121);
				buildqu = TilePosition(46,114);
				buildha1=TilePosition(49,113);
				buildha3=TilePosition(43,124);
				buildha2=TilePosition(75,118);
				buildex2=TilePosition(82,119);
			}
			if(Broodwar->self()->getStartLocation()==TilePosition(7,86))
			{
				buildsp=TilePosition(11,89);
				buildcc1=TilePosition(4,82);
				buildcc2=TilePosition(4,80);
				buildcc3=TilePosition(10,80);
				buildcc4=TilePosition(10,82);
				buildcc5=TilePosition(7,91);
				buildex=TilePosition(6,81);
				buildhd=TilePosition(14,86);
				buildqu = TilePosition(14,84);
				buildha1=TilePosition(14,89);
				buildha3=TilePosition(14,92);
				buildha2=TilePosition(5,52);
				buildex2=TilePosition(7,57);
			}
		}
		//Empire of the Sun
		if(Broodwar->mapHash()=="a220d93efdf05a439b83546a579953c63c863ca7")
		{
			if(top && left)
			{
				buildsp=TilePosition(12,2);
				buildcc1=TilePosition(5,2);
				buildcc2=TilePosition(17,6);
				buildcc3=TilePosition(19,6);
				buildcc4=TilePosition(17,8);
				buildcc5=TilePosition(19,8);
				buildex=TilePosition(7,1);
				buildhd=TilePosition(12,4);
				buildqu = TilePosition(12,6);
				buildha1=TilePosition(8,13);
				buildha3=TilePosition(12,13);
				buildha2=TilePosition(31,6);
				buildex2=TilePosition(29,1);
			}
			if(top && !left)
			{
				buildsp=TilePosition(113,4);
				buildcc1=TilePosition(117,11);
				buildcc2=TilePosition(115,11);
				buildcc3=TilePosition(113,11);
				buildcc4=TilePosition(113,9);
				buildcc5=TilePosition(113,7);
				buildex=TilePosition(117,1);
				buildhd=TilePosition(120,11);
				buildqu = TilePosition(113,2);
				buildha1=TilePosition(108,3);
				buildha3=TilePosition(107,6);
				buildha2=TilePosition(93,6);
				buildex2=TilePosition(95,1);
			}
			if(!top && left)
			{
				buildsp=TilePosition(8,124);
				buildcc1=TilePosition(5,115);
				buildcc2=TilePosition(17,119);
				buildcc3=TilePosition(17,121);
				buildcc4=TilePosition(19,119);
				buildcc5=TilePosition(19,121);
				buildex=TilePosition(7,114);
				buildhd=TilePosition(11,124);
				buildqu = TilePosition(11,122);
				buildha1=TilePosition(7,107);
				buildha3=TilePosition(11,107);
				buildha2=TilePosition(31,118);
				buildex2=TilePosition(29,124);
			}
			if(!top && !left)
			{
				buildsp=TilePosition(113,122);
				buildcc1=TilePosition(121,124);
				buildcc2=TilePosition(111,116);
				buildcc3=TilePosition(113,116);
				buildcc4=TilePosition(111,118);
				buildcc5=TilePosition(113,118);
				buildex=TilePosition(117,114);
				buildhd=TilePosition(116,124);
				buildqu = TilePosition(110,122);
				buildha1=TilePosition(106,115);
				buildha3=TilePosition(106,108);
				buildha2=TilePosition(93,118);
				buildex2=TilePosition(95,124);
			}
		}
	}
};
